unit FrameCapture_;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Menus, VidGrab, MMObj, MMPanel, MMFill,
  MMBmpLst, MMBmpBtn, jpeg, BusinessSkinForm, bsSkinCtrls, bsSkinBoxCtrls;

type
  TTVTuner = class(TForm)
    Image1: TImage;
    GroupBox2: TGroupBox;
    Button6: TButton;
    Button7: TButton;
    Button4: TButton;
    Edit2: TEdit;
    CheckBox3: TCheckBox;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Label1: TLabel;
    Label4: TLabel;
    Button2: TButton;
    Button1: TButton;
    Button5: TButton;
    Button11: TButton;
    Edit3: TEdit;
    Edit1: TEdit;
    Memo1: TMemo;
    bsSkinPanel1: TbsSkinPanel;
    bsSkinPanel2: TbsSkinPanel;
    bsSkinPanel3: TbsSkinPanel;
    VideoGrabber1: TVideoGrabber;
    MMPanelFill3: TMMPanelFill;
    btn_prev: TMMBitmapButton;
    btn_play: TMMBitmapButton;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    StaticText1: TStaticText;
    StaticText2: TStaticText;
    StaticText4: TStaticText;
    bsBusinessSkinForm1: TbsBusinessSkinForm;
    ComboBox1: TbsSkinComboBox;
    ComboBox2: TbsSkinComboBox;
    Bevel4: TBevel;
    ComboBox4: TbsSkinComboBox;
    start: TbsSkinButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure VideoGrabber1ChangeVideoDevice(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure ComboBox4Change(Sender: TObject);
    procedure VideoGrabber1FrameCaptureCompleted(Sender: TObject;
      const FrameData: TFrameData; DestType: TFrameCaptureDest;
      FileName: String; Success: Boolean);
    procedure ComboBox5Change(Sender: TObject);
    procedure DEVICE(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure VideoGrabber1ResizeVideo(Sender: TObject; SourceWidth,
      SourceHeight: Integer);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure startClick(Sender: TObject);
  private
  public
  end;

var
  TVTuner: TTVTuner;

implementation

uses form_mainform;


{$R *.DFM}
//------------------------------------------------------------------------------



procedure TTVTuner.FormCreate(Sender: TObject);
begin

end;
//------------------------------------------------------------------------------

procedure TTVTuner.Button3Click(Sender: TObject);
begin
   VideoGrabber1.StartPreview;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.Button8Click(Sender: TObject);
begin
   VideoGrabber1.StopPreview;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.Button11Click(Sender: TObject);
begin
   VideoGrabber1.BurstType := fc_TBitmap;
   VideoGrabber1.BurstMode := True;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.Button1Click(Sender: TObject);
begin
   VideoGrabber1.BurstType := fc_JpegFile;
   VideoGrabber1.BurstMode := True;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.Button5Click(Sender: TObject);
begin
   VideoGrabber1.BurstType := fc_BmpFile;
   VideoGrabber1.BurstMode := True;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.Button2Click(Sender: TObject);
begin
   VideoGrabber1.BurstMode := False;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.Button4Click(Sender: TObject);
begin
    VideoGrabber1.CaptureFrameTo (fc_TBitmap);
end;
//------------------------------------------------------------------------------

procedure TTVTuner.Button6Click(Sender: TObject);
begin
   if CheckBox3.Checked then begin
      VideoGrabber1.CaptureFrameTo (fc_JpegFile);
   end
   else begin
      VideoGrabber1.CaptureFrameTo (fc_JpegFile, Edit2.Text);
   end;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.Button7Click(Sender: TObject);
begin
   if CheckBox3.Checked then begin
      VideoGrabber1.CaptureFrameTo (fc_BmpFile);
   end
   else begin
      VideoGrabber1.CaptureFrameTo (fc_BmpFile, Edit2.Text);
   end;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.VideoGrabber1FrameCaptureCompleted(Sender: TObject;
  const FrameData: TFrameData; DestType: TFrameCaptureDest;
  FileName: String; Success: Boolean);
begin
   case DestType of
      fc_BmpFile, fc_JPEGFile: begin
        Memo1.Lines.add (FileName + ' created');
      end;
      fc_TBitmap: begin
         Image1.Picture.Bitmap.Assign (FrameData.Bitmap);
         // you can replace the statement above by the faster 2 statements below,
         // because the bitmap is not copied. However be sure not to reuse it several times.
         // (symptom: a black bitmap. In this case use the statement above instead).

         //Image1.Picture.Bitmap.Handle := FrameData.Bitmap.Handle;
         //FrameData.Bitmap.ReleaseHandle;
      end;
   end;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.VideoGrabber1ChangeVideoDevice(Sender: TObject);
begin
   ComboBox1.Items.Text := VideoDevices;
   ComboBox1.ItemIndex := VideoGrabber1.VideoDevice;

   ComboBox2.Items.Text := VideoGrabber1.AnalogVideoStandards;
   ComboBox2.ItemIndex := integer (VideoGrabber1.AnalogVideoStandard);
   ComboBox2.Enabled := VideoGrabber1.IsAnalogVideoDecoderAvailable;

   ComboBox4.Items.Text := VideoGrabber1.VideoCrossbarInputs;
   ComboBox4.ItemIndex := integer (VideoGrabber1.VideoCrossbarInput);
   ComboBox4.Enabled := VideoGrabber1.IsVideoCrossbarAvailable;

   //ComboBox5.Items.Text := VideoGrabber1.VideoSizes;
   //ComboBox5.ItemIndex := integer (VideoGrabber1.VideoSize);

   //Button10.Enabled := VideoGrabber1.IsTVTunerAvailable;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.VideoGrabber1ResizeVideo(Sender: TObject; SourceWidth,
  SourceHeight: Integer);
var
   NewWidth: longint;
begin
   Image1.Picture.Assign (nil);
   Image1.Left := VideoGrabber1.Left + VideoGrabber1.Width + 20;
   Image1.Width := VideoGrabber1.VideoWidth;
   Image1.Height := VideoGrabber1.VideoHeight;
   {
   NewWidth := Image1.Left + VideoGrabber1.Width + 20;
   if NewWidth < GroupBox3.Width + 20 then begin
      NewWidth := GroupBox3.Width + 20;
   end;

   Height := VideoGrabber1.Top + VideoGrabber1.Height + 75;
   Width := NewWidth;
   }
end;
//------------------------------------------------------------------------------

procedure TTVTuner.DEVICE(Sender: TObject);
begin
   VideoGrabber1.ShowDialog (dlg_Device);
end;
//------------------------------------------------------------------------------

procedure TTVTuner.Button10Click(Sender: TObject);
begin
   VideoGrabber1.ShowDialog (dlg_TVTuner);
end;
//------------------------------------------------------------------------------

procedure TTVTuner.ComboBox1Change(Sender: TObject);
begin
   VideoGrabber1.VideoDevice := ComboBox1.ItemIndex;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.ComboBox2Change(Sender: TObject);
begin
   VideoGrabber1.AnalogVideoStandard := ComboBox2.ItemIndex;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.ComboBox4Change(Sender: TObject);
begin
   VideoGrabber1.VideoCrossbarInput := ComboBox4.ItemIndex;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.ComboBox5Change(Sender: TObject);
begin
   //VideoGrabber1.VideoSize := ComboBox5.ItemIndex;
end;
//------------------------------------------------------------------------------

procedure TTVTuner.Edit1Change(Sender: TObject);
begin
   VideoGrabber1.BurstCount := StrToIntDef (Edit1.Text, 0);
end;
//------------------------------------------------------------------------------

procedure TTVTuner.Edit3Change(Sender: TObject);
begin
   VideoGrabber1.BurstInterval := StrToIntDef (Edit3.Text, 0);
end;
//------------------------------------------------------------------------------

procedure TTVTuner.CheckBox3Click(Sender: TObject);
begin
   Edit2.Enabled := not CheckBox3.Checked; // if the file name is not generated automatically, it can be entered
end;
//------------------------------------------------------------------------------

procedure TTVTuner.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  width:=0;
  height:=0;
  TVTuner.FormStyle:=fsnormal;
  TVTuner.Visible:=false;
  mainform.AutoArrange1.Click;
end;

procedure TTVTuner.startClick(Sender: TObject);
begin
   ComboBox1.Items.Text := VideoDevices;
   ComboBox1.ItemIndex := VideoGrabber1.VideoDevice;

   Edit1.Text := IntToStr (VideoGrabber1.BurstCount);
   Edit3.Text := IntToStr (VideoGrabber1.BurstInterval);

   Memo1.Lines.Add ('storage: ' + VideoGrabber1.StoragePath);

   ComboBox2.Items.Text := VideoGrabber1.AnalogVideoStandards;
   ComboBox2.ItemIndex := integer (VideoGrabber1.AnalogVideoStandard);
   ComboBox2.Enabled := VideoGrabber1.IsAnalogVideoDecoderAvailable;
   VideoGrabber1.enabled:=true;
end;

end.
